/*
 * Decompiled with CFR 0.152.
 */
package net.hat.gt.spawning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.hat.gt.entities.GoblinTraderEntity;
import net.hat.gt.init.ModEntities;
import net.hat.gt.spawning.GoblinTraderSpawner;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;

public class SpawnHandler {
    private static Map<class_2960, ArrayList<GoblinTraderSpawner>> spawners = new HashMap<class_2960, ArrayList<GoblinTraderSpawner>>();

    public static Map<class_2960, ArrayList<GoblinTraderSpawner>> getSpawners() {
        return spawners;
    }

    public static void addToSpawners(class_2960 world, GoblinTraderSpawner spawner) {
        if (!spawners.containsKey(world)) {
            spawners.put(world, new ArrayList());
        }
        spawners.get(world).add(spawner);
    }

    public static class OnWorldTick
    implements ServerTickEvents.EndWorldTick {
        public void onEndTick(class_3218 world) {
            if (world.method_8608()) {
                return;
            }
            ArrayList<GoblinTraderSpawner> spawnerList = spawners.get(world.method_27983().method_29177());
            if (spawnerList != null) {
                for (GoblinTraderSpawner spawner : spawnerList) {
                    if (spawner == null) continue;
                    spawner.tick((class_1937)world);
                }
            }
        }
    }

    public static class ServerStopped
    implements ServerLifecycleEvents.ServerStopped {
        public void onServerStopped(MinecraftServer server) {
            spawners.clear();
        }
    }

    public static class WorldLoad
    implements ServerWorldEvents.Load {
        boolean loaded = false;

        public void onWorldLoad(MinecraftServer server, class_3218 world) {
            if (this.loaded) {
                return;
            }
            SpawnHandler.addToSpawners(class_2874.field_24753.method_29177(), new GoblinTraderSpawner(server, "GoblinTrader", ModEntities.GOBLIN_TRADER, Objects.requireNonNull((GoblinTraderEntity)ModEntities.GOBLIN_TRADER.method_5883((class_1937)world))));
            SpawnHandler.addToSpawners(class_2874.field_24754.method_29177(), new GoblinTraderSpawner(server, "VeinGoblinTrader", ModEntities.VEIN_GOBLIN_TRADER, Objects.requireNonNull((GoblinTraderEntity)ModEntities.GOBLIN_TRADER.method_5883((class_1937)world))));
            this.loaded = true;
        }
    }
}

